/*------------------------------------------------------------------------------*
 * File Name:ResultContents.cpp													*
 * Creation: 6/7/2003 CPY														*
 * Purpose: OriginC Source C++ file for Operation Result contents  editing		*
 * Copyright (c) Originlab Corp.	2003										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 * SY 12/29/2004 v8.0181 USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H					*
 *------------------------------------------------------------------------------*/
 
/// SY 12/29/2004 v8.0181 USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H
///#include <Dialog.h>
#include "DialogEx.h"     // Dialog class
/// end USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H
#include <TreeEditor.h>
/// SY 12/29/2004 v8.0181 USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H
///#include "ODlg.h" // resource IDs, ODlg.dll also use this file for its res ids
///#include "HelpID.h"
/// end USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H
#include <utilities.h>
#include <sys_utils.h> // basic routines implemeted through Origin C, see sys_utils.c
#include <tree_utils.h>
///#include "theme_utils.h" // for dialog resize function  /// SY 12/29/2004 v8.0181 USING_DIALOGEX_H_INSTEAD_OF_DIALOG_H

bool ResultContents(TreeNode& trReporting, HWND hWndParent = NULL)
{
	ResultContentsDlg MyDlg(trReporting.Header.Table);
	
 	int nRet = MyDlg.DoModalEx(hWndParent);

 	return nRet == IDOK? true:false;
}

class ResultContentsDlg : public Dialog
{
private:	
	TreeNode		m_trInput;
	TreeEditor 		m_treeEditor;
public:
	ResultContentsDlg(TreeNode& trReporting):Dialog(IDD_REPORT_CONTENT, "ODlg")
	{
		m_trInput = trReporting; // save original tree node
	}
	
	int  	DoModalEx(HWND hParent)
	{
		InitMsgMap();// will be called from internal later
		int nRet = DoModal(hParent);
		return nRet;
	}
	
		
///----------------- Message Map ----------------
EVENTS_BEGIN
	ON_INIT(OnInitDialog) 
	ON_OK(OnOK)
	ON_SIZE(OnDlgResize)
	ON_USER_MSG(WM_USER_ON_CONTROL_CHANGE, OnTreeChanged)
EVENTS_END
///----------------------------------------------
		
		
	///////////////////////////////////////////////////////
	/// Event Handlers
	///////////////////////////////////////////////////////
	
	BOOL OnInitDialog()
	{
		// load from s_strTempFilename
		m_treeEditor = GetItem(IDC_REPORT_CONTENT);
		m_treeEditor.Root = m_trInput;
		
		return TRUE;	
	}
	

	BOOL OnOK()
	{	
		m_trInput.Replace(m_treeEditor.Root);
		return TRUE;
	}
	
	BOOL OnTreeChanged(uint wParam, uint lParam)
	{
		return TRUE;
	}
	
	BOOL OnDlgResize(int nType, int cx, int cy)
	{
		uint nBtnIds[] = {
			IDOK,
			IDCANCEL,
			0};
		
		dlg_resize_buttons_relative_to_main_item(*this, nBtnIds, IDC_REPORT_CONTENT, cx, cy);
			
		return TRUE;
	}


};

